<?php
// Define admin access for security
define('ADMIN_ACCESS', true);

// Include required files
require_once __DIR__ . '/config/constants.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/functions.php';

echo "<h1>Quick Database Setup</h1>";

try {
    $db = Database::getInstance();
    echo "✅ Database connection successful<br>";
    
    // Check if tables exist
    $tables = ['admins', 'users', 'levels', 'game_plays', 'activity_logs', 'settings'];
    
    foreach ($tables as $table) {
        $result = $db->query("SHOW TABLES LIKE '$table'");
        if ($result->rowCount() > 0) {
            echo "✅ Table '$table' exists<br>";
        } else {
            echo "❌ Table '$table' missing<br>";
        }
    }
    
    // Check if admin user exists
    $admin = fetch("SELECT * FROM admins WHERE username = 'admin'");
    if ($admin) {
        echo "✅ Admin user exists<br>";
    } else {
        echo "❌ Admin user missing<br>";
        // Create admin user
        $hashed_password = password_hash('admin123', PASSWORD_ARGON2ID);
        $db->query("INSERT INTO admins (username, email, password, role) VALUES ('admin', 'admin@example.com', '$hashed_password', 'admin')");
        echo "✅ Admin user created<br>";
    }
    
    // Add sample data if tables are empty
    $userCount = fetch("SELECT COUNT(*) as count FROM users")->fetchColumn();
    if ($userCount == 0) {
        echo "Adding sample users...<br>";
        $db->query("INSERT INTO users (username, email, password, coins, hints, undos, current_level, games_played, games_won) VALUES
            ('player1', 'player1@example.com', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 150, 8, 15, 2, 5, 3),
            ('player2', 'player2@example.com', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 75, 3, 8, 1, 3, 1),
            ('player3', 'player3@example.com', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 200, 12, 20, 3, 8, 6)");
        echo "✅ Sample users added<br>";
    }
    
    $levelCount = fetch("SELECT COUNT(*) as count FROM levels")->fetchColumn();
    if ($levelCount == 0) {
        echo "Adding sample levels...<br>";
        $db->query("INSERT INTO levels (level_number, name, description, difficulty, bottles_count, colors_count, bottle_capacity, initial_state, solution_moves, reward_coins) VALUES
            (1, 'Getting Started', 'Learn the basics of water sorting', 'Easy', 4, 2, 4, '[\"red,red,blue,blue\", \"blue,red,blue,red\", \"\", \"\"]', 3, 10),
            (2, 'Mixing Colors', 'Three colors make it more challenging', 'Easy', 5, 3, 4, '[\"red,red,blue,blue\", \"blue,green,green,red\", \"green,blue,red,green\", \"\", \"\"]', 5, 15),
            (3, 'Triple Challenge', 'More bottles, more complexity', 'Medium', 6, 3, 4, '[\"red,green,blue,red\", \"blue,red,green,blue\", \"green,blue,red,green\", \"\", \"\", \"\"]', 7, 20)");
        echo "✅ Sample levels added<br>";
    }
    
    echo "<br>✅ Setup complete! <a href='modules/dashboard.php'>Go to Dashboard</a>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    echo "<br><a href='setup.php'>Run Full Setup</a>";
}
?>
