<?php
// Prevent direct access
if (!defined('ADMIN_ACCESS')) {
    header('HTTP/1.0 403 Forbidden');
    exit('Direct access not permitted');
}

// Get current page for active state
$current_page = basename($_SERVER['PHP_SELF']);
?>
<nav class="sidebar-nav">
    <ul class="nav-list">
        <li class="nav-item">
            <a href="<?php echo ADMIN_URL; ?>/modules/dashboard.php" 
               class="nav-link <?php echo $current_page === 'dashboard.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📊</span>
                <span class="nav-text">Dashboard</span>
            </a>
        </li>
        
        <li class="nav-group">
            <div class="nav-group-title">User Management</div>
            <ul class="nav-sublist">
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/users.php" 
                       class="nav-link <?php echo $current_page === 'users.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">👥</span>
                        <span class="nav-text">Users</span>
                    </a>
                </li>
            </ul>
        </li>
        
        <li class="nav-group">
            <div class="nav-group-title">Game Management</div>
            <ul class="nav-sublist">
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/levels.php" 
                       class="nav-link <?php echo in_array($current_page, ['levels.php', 'add-level.php', 'edit-level.php']) ? 'active' : ''; ?>">
                        <span class="nav-icon">🎮</span>
                        <span class="nav-text">Levels</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/add-level.php" 
                       class="nav-link <?php echo $current_page === 'add-level.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">➕</span>
                        <span class="nav-text">Add Level</span>
                    </a>
                </li>
            </ul>
        </li>
        
        <li class="nav-group">
            <div class="nav-group-title">Analytics</div>
            <ul class="nav-sublist">
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/analytics.php" 
                       class="nav-link <?php echo $current_page === 'analytics.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">📈</span>
                        <span class="nav-text">Analytics</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/reports.php" 
                       class="nav-link <?php echo $current_page === 'reports.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">📋</span>
                        <span class="nav-text">Reports</span>
                    </a>
                </li>
            </ul>
        </li>
        
        <li class="nav-group">
            <div class="nav-group-title">Settings</div>
            <ul class="nav-sublist">
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/settings.php" 
                       class="nav-link <?php echo $current_page === 'settings.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">⚙️</span>
                        <span class="nav-text">Settings</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo ADMIN_URL; ?>/modules/logs.php" 
                       class="nav-link <?php echo $current_page === 'logs.php' ? 'active' : ''; ?>">
                        <span class="nav-icon">📝</span>
                        <span class="nav-text">Activity Logs</span>
                    </a>
                </li>
            </ul>
        </li>
        
        <li class="nav-divider"></li>
        
        <li class="nav-item">
            <a href="<?php echo ADMIN_URL; ?>/auth/logout.php" class="nav-link logout-link">
                <span class="nav-icon">🚪</span>
                <span class="nav-text">Logout</span>
            </a>
        </li>
    </ul>
    
    <!-- Quick Stats -->
    <div class="sidebar-stats">
        <div class="stat-item">
            <div class="stat-label">System Status</div>
            <div class="stat-value">
                <span class="status-indicator online"></span>
                Online
            </div>
        </div>
        <div class="stat-item">
            <div class="stat-label">Database</div>
            <div class="stat-value">
                <span class="status-indicator online"></span>
                Connected
            </div>
        </div>
        <div class="stat-item">
            <div class="stat-label">PHP Version</div>
            <div class="stat-value"><?php echo PHP_VERSION; ?></div>
        </div>
    </div>
</nav>

<!-- Mobile Menu Toggle -->
<button class="mobile-menu-toggle" id="mobileMenuToggle">
    <span></span>
    <span></span>
    <span></span>
</button>

<script>
    // Mobile menu toggle
    document.getElementById('mobileMenuToggle').addEventListener('click', function() {
        document.querySelector('.admin-sidebar').classList.toggle('mobile-open');
        document.body.classList.toggle('sidebar-open');
    });
    
    // Close mobile menu when clicking outside
    document.addEventListener('click', function(event) {
        const sidebar = document.querySelector('.admin-sidebar');
        const toggle = document.getElementById('mobileMenuToggle');
        
        if (!sidebar.contains(event.target) && !toggle.contains(event.target)) {
            sidebar.classList.remove('mobile-open');
            document.body.classList.remove('sidebar-open');
        }
    });
    
    // Handle nav group toggles on mobile
    const navGroups = document.querySelectorAll('.nav-group');
    navGroups.forEach(group => {
        const title = group.querySelector('.nav-group-title');
        if (title) {
            title.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    group.classList.toggle('mobile-expanded');
                }
            });
        }
    });
</script>
