<?php
// Prevent direct access
if (!defined('ADMIN_ACCESS')) {
    header('HTTP/1.0 403 Forbidden');
    exit('Direct access not permitted');
}

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (!Auth::isLoggedIn()) {
    header('Location: ' . ADMIN_URL . '/auth/login.php');
    exit;
}

// Check session timeout
$last_activity = $_SESSION['last_activity'] ?? 0;
if (time() - $last_activity > SESSION_TIMEOUT) {
    // Session expired
    Auth::logout();
    header('Location: ' . ADMIN_URL . '/auth/login.php?timeout=1');
    exit;
}

// Update last activity time
$_SESSION['last_activity'] = time();

// Get page title from variable or use default
$page_title = $page_title ?? 'Admin Panel';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo htmlspecialchars($page_title); ?> - Water Sort Game Admin</title>
    
    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo ADMIN_URL; ?>/assets/css/admin.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo ADMIN_URL; ?>/assets/favicon.ico">
    
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo generateCSRFToken(); ?>">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <aside class="admin-sidebar" id="adminSidebar">
            <div class="sidebar-header">
                <a href="<?php echo ADMIN_URL; ?>/modules/dashboard.php" class="sidebar-logo">
                    <div class="logo-icon">💧</div>
                    <span class="sidebar-text">Water Sort Game</span>
                </a>
            </div>
            
            <nav class="sidebar-nav">
                <ul class="nav-list">
                    <li class="nav-item">
                        <a href="<?php echo ADMIN_URL; ?>/modules/dashboard.php" class="nav-link <?php echo $current_page === 'dashboard.php' ? 'active' : ''; ?>">
                            <span class="nav-icon">�</span>
                            <span class="nav-text">Dashboard</span>
                        </a>
                    </li>
                    
                    <li class="nav-group">
                        <div class="nav-group-title">User Management</div>
                        <ul class="nav-sublist">
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/users.php" class="nav-link <?php echo $current_page === 'users.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">👥</span>
                                    <span class="nav-text">Users</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-group">
                        <div class="nav-group-title">Game Management</div>
                        <ul class="nav-sublist">
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/levels.php" class="nav-link <?php echo in_array($current_page, ['levels.php', 'add-level.php', 'edit-level.php']) ? 'active' : ''; ?>">
                                    <span class="nav-icon">🎮</span>
                                    <span class="nav-text">Levels</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/add-level.php" class="nav-link <?php echo $current_page === 'add-level.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">➕</span>
                                    <span class="nav-text">Add Level</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-group">
                        <div class="nav-group-title">Analytics</div>
                        <ul class="nav-sublist">
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/analytics.php" class="nav-link <?php echo $current_page === 'analytics.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">📈</span>
                                    <span class="nav-text">Analytics</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/reports.php" class="nav-link <?php echo $current_page === 'reports.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">📋</span>
                                    <span class="nav-text">Reports</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-group">
                        <div class="nav-group-title">Settings</div>
                        <ul class="nav-sublist">
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/settings.php" class="nav-link <?php echo $current_page === 'settings.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">⚙️</span>
                                    <span class="nav-text">Settings</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo ADMIN_URL; ?>/modules/activity-logs.php" class="nav-link <?php echo $current_page === 'activity-logs.php' ? 'active' : ''; ?>">
                                    <span class="nav-icon">📝</span>
                                    <span class="nav-text">Activity Logs</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-divider"></li>
                    
                    <li class="nav-item">
                        <a href="<?php echo ADMIN_URL; ?>/auth/logout.php" class="nav-link logout-link">
                            <span class="nav-icon">🚪</span>
                            <span class="nav-text">Logout</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </aside>
        
        <div class="admin-body">
            <!-- Header -->
            <header class="admin-header">
                <div class="header-content">
                    <div class="header-left">
                        <button class="mobile-menu-toggle" id="mobileMenuToggle">
                            <span></span>
                            <span></span>
                            <span></span>
                        </button>
                        <h1 class="logo">
                            <a href="<?php echo ADMIN_URL; ?>/modules/dashboard.php">
                                💧 Water Sort Game
                            </a>
                        </h1>
                        <span class="subtitle">Admin Panel</span>
                    </div>
                    
                    <div class="header-right">
                        <div class="admin-info">
                            <span class="welcome-text">
                                Welcome, <strong><?php echo htmlspecialchars($_SESSION['admin_username']); ?></strong>
                            </span>
                            <span class="last-login">
                                Last login: <?php echo formatDate($_SESSION['login_time'] ?? date('Y-m-d H:i:s')); ?>
                            </span>
                        </div>
                        
                        <nav class="header-nav">
                            <a href="<?php echo ADMIN_URL; ?>/modules/dashboard.php" class="nav-link-btn" title="Dashboard">
                                📊
                            </a>
                            <a href="<?php echo ADMIN_URL; ?>/auth/logout.php" class="nav-link-btn logout-btn" title="Logout">
                                🚪
                            </a>
                        </nav>
                    </div>
                </div>
            </header>
            
            <!-- Main Content -->
            <main class="admin-main">
