<?php
// Debug script to check what's causing the white screen
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Debug Information</h1>";

echo "<h2>1. Checking constants.php</h2>";
if (file_exists(__DIR__ . '/config/constants.php')) {
    echo "✅ constants.php exists<br>";
    include __DIR__ . '/config/constants.php';
    echo "✅ constants.php loaded<br>";
    echo "ADMIN_URL: " . ADMIN_URL . "<br>";
} else {
    echo "❌ constants.php missing<br>";
}

echo "<h2>2. Checking database.php</h2>";
if (file_exists(__DIR__ . '/config/database.php')) {
    echo "✅ database.php exists<br>";
    try {
        include __DIR__ . '/config/database.php';
        echo "✅ database.php loaded<br>";
    } catch (Exception $e) {
        echo "❌ database.php error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ database.php missing<br>";
}

echo "<h2>3. Checking functions.php</h2>";
if (file_exists(__DIR__ . '/config/functions.php')) {
    echo "✅ functions.php exists<br>";
    include __DIR__ . '/config/functions.php';
    echo "✅ functions.php loaded<br>";
} else {
    echo "❌ functions.php missing<br>";
}

echo "<h2>4. Checking security.php</h2>";
if (file_exists(__DIR__ . '/includes/security.php')) {
    echo "✅ security.php exists<br>";
    try {
        include __DIR__ . '/includes/security.php';
        echo "✅ security.php loaded<br>";
    } catch (Exception $e) {
        echo "❌ security.php error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ security.php missing<br>";
}

echo "<h2>5. Testing database connection</h2>";
try {
    $db = Database::getInstance();
    echo "✅ Database connection successful<br>";
} catch (Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "<br>";
}

echo "<h2>6. Testing Auth class</h2>";
if (class_exists('Auth')) {
    echo "✅ Auth class exists<br>";
    if (method_exists('Auth', 'isLoggedIn')) {
        echo "✅ Auth::isLoggedIn method exists<br>";
    } else {
        echo "❌ Auth::isLoggedIn method missing<br>";
    }
} else {
    echo "❌ Auth class missing<br>";
}

echo "<h2>7. PHP Version</h2>";
echo "PHP Version: " . phpversion() . "<br>";

echo "<h2>8. File permissions</h2>";
$files = [
    'config/constants.php',
    'config/database.php', 
    'config/functions.php',
    'includes/security.php',
    'auth/login.php'
];

foreach ($files as $file) {
    $filepath = __DIR__ . '/' . $file;
    if (file_exists($filepath)) {
        echo "✅ $file - readable<br>";
    } else {
        echo "❌ $file - missing<br>";
    }
}

echo "<h2>9. Session status</h2>";
echo "Session status: " . session_status() . "<br>";
echo "Session ID: " . session_id() . "<br>";

echo "<p><a href='auth/login.php'>Try Login Page Again</a></p>";
?>
